<?php
// index.php - AuroraPro Premium v2
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AuroraPro Premium - Portafolio Profesional</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
</head>
<body>
    <!-- Header -->
    <header>
        <div class="container header-container">
            <h1 class="logo">AuroraPro</h1>
            <nav>
                <div class="menu-toggle" id="mobile-menu">
                    <span class="bar"></span>
                    <span class="bar"></span>
                    <span class="bar"></span>
                </div>
                <ul class="nav-list">
                    <li><a href="#inicio">Inicio</a></li>
                    <li><a href="#servicios">Servicios</a></li>
                    <li><a href="#portfolio">Portfolio</a></li>
                    <li><a href="#testimonios">Testimonios</a></li>
                    <li><a href="#contacto">Contacto</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <!-- Hero Section -->
    <section id="inicio" class="hero">
        <div class="hero-overlay"></div>
        <div class="container hero-container">
            <h2>Innovación y Creatividad para tu Negocio</h2>
            <p>Llevamos tu empresa al siguiente nivel con soluciones digitales modernas y efectivas.</p>
            <a href="#contacto" class="btn-primary">Contáctanos</a>
        </div>
    </section>

    <!-- Servicios -->
    <section id="servicios" class="servicios">
        <div class="container">
            <h2>Nuestros Servicios</h2>
            <div class="servicios-grid">
                <div class="servicio-card">
                    <img src="https://images.unsplash.com/photo-1593642634315-48f5414c3ad9?auto=format&fit=crop&w=400&q=80" alt="Desarrollo Web">
                    <h3>Desarrollo Web</h3>
                    <p>Diseños web modernos, funcionales y responsivos para empresas de cualquier tamaño.</p>
                </div>
                <div class="servicio-card">
                    <img src="https://images.unsplash.com/photo-1518779578993-ec3579fee39f?auto=format&fit=crop&w=400&q=80" alt="Diseño Gráfico">
                    <h3>Diseño Gráfico</h3>
                    <p>Visuales impactantes que reflejan la esencia de tu marca y atraen clientes.</p>
                </div>
                <div class="servicio-card">
                    <img src="https://images.unsplash.com/photo-1559526324-593bc073d938?auto=format&fit=crop&w=400&q=80" alt="Marketing Digital">
                    <h3>Marketing Digital</h3>
                    <p>Estrategias efectivas para aumentar tu presencia online y convertir visitantes en clientes.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Portfolio -->
    <section id="portfolio" class="portfolio">
        <div class="container">
            <h2>Proyectos Recientes</h2>
            <div class="portfolio-grid">
                <div class="portfolio-item" style="background-image: url('https://images.unsplash.com/photo-1581091012184-74e5fae6d4c4?auto=format&fit=crop&w=600&q=80');">
                    <div class="portfolio-overlay">
                        <h3>Proyecto 1</h3>
                        <p>Descripción breve del proyecto.</p>
                    </div>
                </div>
                <div class="portfolio-item" style="background-image: url('https://images.unsplash.com/photo-1519389950473-47ba0277781c?auto=format&fit=crop&w=600&q=80');">
                    <div class="portfolio-overlay">
                        <h3>Proyecto 2</h3>
                        <p>Descripción breve del proyecto.</p>
                    </div>
                </div>
                <div class="portfolio-item" style="background-image: url('https://images.unsplash.com/photo-1521737604893-d14cc237f11d?auto=format&fit=crop&w=600&q=80');">
                    <div class="portfolio-overlay">
                        <h3>Proyecto 3</h3>
                        <p>Descripción breve del proyecto.</p>
                    </div>
                </div>
                <div class="portfolio-item" style="background-image: url('https://images.unsplash.com/photo-1581092580498-6b1c7b64cd10?auto=format&fit=crop&w=600&q=80');">
                    <div class="portfolio-overlay">
                        <h3>Proyecto 4</h3>
                        <p>Descripción breve del proyecto.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonios -->
    <section id="testimonios" class="testimonios">
        <div class="container">
            <h2>Lo que dicen nuestros clientes</h2>
            <div class="testimonios-grid">
                <div class="testimonial">
                    <p>"AuroraPro transformó nuestra presencia digital, con un diseño increíble y funcional."</p>
                    <span>- Cliente Satisfecho</span>
                </div>
                <div class="testimonial">
                    <p>"Profesionales, creativos y siempre cumpliendo en tiempo y forma."</p>
                    <span>- Cliente Feliz</span>
                </div>
                <div class="testimonial">
                    <p>"Su equipo nos ayudó a crecer online de manera rápida y efectiva."</p>
                    <span>- Empresa XYZ</span>
                </div>
            </div>
        </div>
    </section>

    <!-- Contacto -->
    <section id="contacto" class="contacto">
        <div class="container">
            <h2>Contáctanos</h2>
            <form action="#" method="POST" class="contact-form">
                <input type="text" name="nombre" placeholder="Nombre" required>
                <input type="email" name="email" placeholder="Correo" required>
                <textarea name="mensaje" placeholder="Mensaje" rows="5" required></textarea>
                <button type="submit" class="btn-primary">Enviar</button>
            </form>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container footer-container">
            <p>&copy; 2025 AuroraPro. Todos los derechos reservados.</p>
            <div class="socials">
                <a href="#">Facebook</a>
                <a href="#">Instagram</a>
                <a href="#">LinkedIn</a>
            </div>
        </div>
    </footer>

<script>
    // Menu móvil
    const mobileMenu = document.getElementById('mobile-menu');
    const navList = document.querySelector('.nav-list');

    mobileMenu.addEventListener('click', () => {
        navList.classList.toggle('active');
    });
</script>

</body>
</html>
